/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class GlobalTravellerModifier
extends Modifier
implements TooltipModifierHook,
BlockInteractionModifierHook,
ProcessLootModifierHook {
    public static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = ForgeCapabilities.ITEM_HANDLER;
    private final ResourceLocation X = new ResourceLocation("tinkerscalibration", "global_traveller_x");
    private final ResourceLocation Y = new ResourceLocation("tinkerscalibration", "global_traveller_y");
    private final ResourceLocation Z = new ResourceLocation("tinkerscalibration", "global_traveller_z");
    private final ResourceLocation WORLD = new ResourceLocation("tinkerscalibration", "global_traveller_dimension");
    private static final Component GLOBAL_POS = TConstruct.makeTranslation((String)"modifier", (String)"global_traveller.pos");
    private static final String UNLINK_SUCCEED = Mantle.makeDescriptionId((String)"modifier", (String)"global_traveller.unlink");
    private static final String LINK_SUCCEED = Mantle.makeDescriptionId((String)"modifier", (String)"global_traveller.link");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.TOOLTIP, ModifierHooks.BLOCK_INTERACT, ModifierHooks.PROCESS_LOOT);
    }

    public int getPriority() {
        return 10;
    }

    @NotNull
    public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && tool.getCurrentDurability() >= 10 && context.m_43723_() != null && context.m_43723_().m_6047_() || tool.hasTag(TinkerTags.Items.RANGED) && source == InteractionSource.LEFT_CLICK && tool.getCurrentDurability() >= 10 && context.m_43723_() != null && context.m_43723_().m_6047_()) {
            BlockPos pos;
            Level world;
            BlockEntity block;
            Player player = context.m_43723_();
            if (!context.m_43725_().f_46443_ && player != null && (block = (world = context.m_43725_()).m_7702_(pos = context.m_8083_())) != null && block.getCapability(ITEM_HANDLER_CAPABILITY).isPresent()) {
                ModDataNBT persistentData = tool.getPersistentData();
                if (persistentData.contains(this.X, 3) && persistentData.contains(this.Y, 3) && persistentData.contains(this.Z, 3) && persistentData.contains(this.WORLD, 8)) {
                    if (persistentData.getInt(this.X) == pos.m_123341_() && persistentData.getInt(this.Y) == pos.m_123342_() && persistentData.getInt(this.Z) == pos.m_123343_() && persistentData.getString(this.WORLD).equals(world.m_46472_().m_135782_().m_135815_())) {
                        persistentData.remove(this.X);
                        persistentData.remove(this.Y);
                        persistentData.remove(this.Z);
                        persistentData.remove(this.WORLD);
                        player.m_5661_((Component)Component.m_237110_((String)UNLINK_SUCCEED, (Object[])new Object[]{pos.m_123344_(), world.m_46472_().m_135782_().m_135815_()}), true);
                    } else {
                        persistentData.putInt(this.X, pos.m_123341_());
                        persistentData.putInt(this.Y, pos.m_123342_());
                        persistentData.putInt(this.Z, pos.m_123343_());
                        persistentData.putString(this.WORLD, world.m_46472_().m_135782_().m_135815_());
                        player.m_5661_((Component)Component.m_237110_((String)LINK_SUCCEED, (Object[])new Object[]{pos.m_123344_(), world.m_46472_().m_135782_().m_135815_()}), true);
                    }
                } else {
                    persistentData.putInt(this.X, pos.m_123341_());
                    persistentData.putInt(this.Y, pos.m_123342_());
                    persistentData.putInt(this.Z, pos.m_123343_());
                    persistentData.putString(this.WORLD, world.m_46472_().m_135782_().m_135815_());
                    player.m_5661_((Component)Component.m_237110_((String)LINK_SUCCEED, (Object[])new Object[]{pos.m_123344_(), world.m_46472_().m_135782_().m_135815_()}), true);
                }
                player.m_36335_().m_41524_(tool.getItem(), 40);
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)5, (LivingEntity)player);
                return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.X, 3) && persistentData.contains(this.Y, 3) && persistentData.contains(this.Z, 3) && persistentData.contains(this.WORLD, 8)) {
            BlockEntity block;
            BlockPos pos = new BlockPos(persistentData.getInt(this.X), persistentData.getInt(this.Y), persistentData.getInt(this.Z));
            ServerLevel level = context.m_78952_().m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(persistentData.getString(this.WORLD))));
            if (level != null && (block = level.m_7702_(pos)) != null) {
                IItemHandler inventory = (IItemHandler)block.getCapability(ITEM_HANDLER_CAPABILITY).orElse(null);
                Iterator<ItemStack> iterator = generatedLoot.iterator();
                ArrayList<ItemStack> leftover = new ArrayList<ItemStack>();
                while (iterator.hasNext()) {
                    ItemStack stack = iterator.next();
                    leftover.add(ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)false));
                }
                generatedLoot.clear();
                generatedLoot.addAll(leftover);
            }
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (player != null) {
            if (persistentData.contains(this.X, 3) && persistentData.contains(this.Y, 3) && persistentData.contains(this.Z, 3)) {
                BlockPos pos = new BlockPos(persistentData.getInt(this.X), persistentData.getInt(this.Y), persistentData.getInt(this.Z));
                Level world = player.m_9236_();
                tooltip.add((Component)Component.m_237115_((String)MoreObjects.toStringHelper((String)"").add("X", pos.m_123341_()).add(" Y", pos.m_123342_()).add(" Z", pos.m_123343_()).toString()).m_130946_(" ").m_130946_(persistentData.getString(this.WORLD)).m_130946_(" ").m_7220_(GLOBAL_POS).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
                if (world.m_46472_().m_135782_().m_135815_().equals(persistentData.getString(this.WORLD))) {
                    BlockEntity block = world.m_7702_(pos);
                    if (block != null) {
                        if (block.getCapability(ITEM_HANDLER_CAPABILITY).isPresent()) {
                            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.global.valid").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
                        } else {
                            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.global.invalid").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
                        }
                    } else {
                        tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.global.invalid").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
                    }
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.global.different_dimension").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.global.none").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)14850796))));
            }
        }
    }
}

